function [ Rx,Ry1,Ry2,S_13,S_12,S_23,s_13,s_12,s_23,ux,uy,results ] = truss( E,A,P,fi,L1,L2,H )

%Sunartisi pou epiluei diktuwma upo ekswteriki sugkentrwmeni dunami
%Dedomena:
%E: metro elastikotitas se (kPa)
%A: emvado diatomis se (m^2)
%P: ekswteriki dunami se (kN)
%fi: gwnia upovolis se (rad) 0<fi</2
%L1,L2: sunoliko anoigma se (m)
%H: upsos se (m)


% % Thewroume thetikes fores pros ta panw kai deksia,
% % enw gia tis ravdous oi efelkustikes taseis thetikes.

f312 = atan(H/L1);
f123 = atan(H/L2);
Length_13 = sqrt(L1^2+H^2);
Length_23 = sqrt(L2^2+H^2);

Rx = -P*cos(fi);
Ry2 = (P*sin(fi)*L1+P*cos(fi)*H)/(L1+L2);
Ry1 = P*sin(fi)-Ry2;

S_13 = Ry1/sin(f312);
S_12 = -(Rx+S_13*cos(f312));
S_23 = Ry2/sin(f123);

s_13 = S_13/A;
s_12 = S_12/A;
s_23 = S_23/A;

dl_13 = (s_13/E)*Length_13;
dl_23 = (s_23/E)*Length_23;

ux_13 = dl_13*cos(f312);
uy_13 = dl_13*sin(f312);
ux_23 = dl_23*cos(f123);
uy_23 = dl_23*sin(f123);

ux = ux_13+ux_23;
uy = uy_13+uy_23;

R = [Rx Ry1 Ry2];
S = [S_13 S_12 S_23];
s = [s_13 s_12 s_23];
u = [ux uy];

results = [R S s u];
end