clear;clc;

fid=fopen('bathmologia.txt');

line=fgetl(fid);
bat=struct('onoma',{},'epitheto',{},'e3amino',{});

i=0;
sums_M=zeros(8,1);
while feof(fid)==0
    i=i+1;
    
    line=fgetl(fid);
    k=find(line==',');
    
    bat(i).onoma     = line(1:k(1)-1);
    bat(i).epitheto  = line(k(1)+2:k(2)-1);
    bat(i).e3amino   = line(k(2)+2:k(3)-1);
    
    bat(i).grades.analisi_1     =   sscanf(line(k(3)+1:k(4)-1),'%f');
    sums_M(1)=sums_M(1)+bat(i).grades.analisi_1;
    bat(i).grades.fusiki        =   sscanf(line(k(4)+1:k(5)-1),'%f');
    sums_M(2)=sums_M(2)+bat(i).grades.fusiki;
    bat(i).grades.geodesia      =   sscanf(line(k(5)+1:k(6)-1),'%f');
    sums_M(3)=sums_M(3)+bat(i).grades.geodesia;
    bat(i).grades.geologia      =   sscanf(line(k(6)+1:k(7)-1),'%f');
    sums_M(4)=sums_M(4)+bat(i).grades.geologia;
    bat(i).grades.statiki_1     =   sscanf(line(k(7)+1:k(8)-1),'%f');
    sums_M(5)=sums_M(5)+bat(i).grades.statiki_1;
    bat(i).grades.odopoiia      =   sscanf(line(k(8)+1:k(9)-1),'%f');
    sums_M(6)=sums_M(6)+bat(i).grades.odopoiia;
    bat(i).grades.edafomixaniki =   sscanf(line(k(9)+1:k(10)-1),'%f');
    sums_M(7)=sums_M(7)+bat(i).grades.edafomixaniki;
    bat(i).grades.hydrauliki    =   sscanf(line(k(10)+1:end),'%f');
    sums_M(8)=sums_M(8)+bat(i).grades.hydrauliki;
end

save('bathmologia.mat','bat')

C=zeros(20,8);
for i=1:20
    %metafora twn vathmwn apo th domi se pinaka gia prakseis
    C(i,:)=cell2mat(struct2cell(bat(i).grades));
    sum=0;
    count=0;
    for j=1:8
        if C(i,j)>=5
            sum=C(i,j)+sum;
            count=count+1;
            bat(i).mean=(sum/count);
        elseif C(i,:)<5
            bat(i).mean='-';
        end
    end
end

Means_course_array=sums_M/20; %pinakas me tous mesous orous mathimatos

Means_course=struct('analisi_1',Means_course_array(1),...
    'fusiki',Means_course_array(2),'geodesia',Means_course_array(3),...
'geologia',Means_course_array(4),'statiki_1',Means_course_array(5),...
'odopoiia',Means_course_array(6),'edafomixaniki',Means_course_array(7),...
'hydrauliki',Means_course_array(8));

msg1='Oi mesoi oroi kathe mathimatos katagrafikan sth domi Means_course,';
msg2='opws fainetai parakatw:';

fprintf('%s \n%s \n\n', msg1, msg2)
disp(Means_course)