clear;clc;close all;

load -ascii 'earthquake1.dat'
load -ascii 'earthquake2.dat'

%%%
plithos_timwn=size(earthquake1,1);
msg1=['To plithos twn timwn einai ',num2str(plithos_timwn),'.'];
disp(msg1)

time_step=0.02;
time_run=plithos_timwn*time_step;
msg2=['H xroniki diarkeia katagrafis einai ',num2str(time_run),'s.'];
disp(msg2)
time_axis=0.02:time_step:time_run;

g=981; % cm/sec^2
earthquake1=earthquake1/g;
earthquake2=earthquake2/g;

hold on

plot(time_axis,earthquake1)
plot(time_axis,earthquake2,'magenta')

title('Acceleration versus Time')
xlabel('Time (sec)')
ylabel('Acceleration (g)')

grid on
grid minor

% Megisto earthquake1
tmp1=max(abs(earthquake1));
index1=find(abs(earthquake1)==tmp1);

plot(time_axis(index1),earthquake1(index1),'red.','Markersize',25);
maxA1=earthquake1(index1);
text(time_axis(index1)+1.55,earthquake1(index1)+0.035,['A1 = ',num2str(maxA1)])

% Megisto earthquake2
tmp2=max(abs(earthquake2));
index2=find(abs(earthquake2)==tmp2);

plot(time_axis(index2),earthquake2(index2),'red.','Markersize',25);
maxA2=earthquake2(index2);
text(time_axis(index2)+1.5,earthquake2(index2)+0.1,['A2 = ',num2str(maxA2)])

hold off

savefig('Acceleration versus Time.fig') %enallaktika 'hgsave'